<?php
// Do not delete these lines
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

	if ( post_password_required() ) { ?>
		<p class="nocomments">Этот пост защищен паролем. Введите пароль для просмотра комментариев.</p>
	<?php
		return;
	}
?>

<!-- You can start editing here. -->

<?php if ( have_comments() ) : ?>
	<h3 id="comments"><?php comments_number('Пока нет комментариев.', 'Есть 1 комментарий.', 'Есть % коммент.');?> к &#8220;<?php the_title(); ?>&#8221;</h3>

	<ol class="commentlist"><?php wp_list_comments(); ?></ol>
    

 <?php else : // this is displayed if there are no comments so far ?>

	<?php if ( comments_open() ) : ?>
		<!-- If comments are open, but there are no comments. -->

	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<p class="nocomments">Комментарии закрыты.</p>

	<?php endif; ?>
    
<?php endif; ?>


<?php if ( comments_open() ) : ?>

<div id="respond">

	<h3 class="commenttitle"><?php comment_form_title( 'Написать ответ', 'Написать ответ к %s' ); ?></h3>

    <div class="cancel-comment-reply">
        <small><?php cancel_comment_reply_link(); ?></small>
    </div>

	<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
    	<p>Вы должны <a href="<?php echo wp_login_url( get_permalink() ); ?>">войти</a> чтобы оставить комментарий.</p>
    <?php else : ?>

        <div id="commentform">
            <form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post">
        
                <?php if ( is_user_logged_in() ) : ?>
        
                    <p>Вы вошли как <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Выйти из этой учетной записи">Выйти &raquo;</a></p>
        
                <?php else : ?>
        
                    <p><input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> />
                    <label for="author"><small>Имя <?php if ($req) echo "(обязательно)"; ?></small></label></p>
            
                    <p><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> />
                    <label for="email"><small>Mail (скрыто) <?php if ($req) echo "(обязательно)"; ?></small></label></p>
                    
                    <p><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" />
                    <label for="url"><small>Сайт</small></label></p>
        
                <?php endif; ?>
        <?php /* Локализация шаблона - FreeWordpressThemes.ru */ ?>
                <!--<p><small><strong>XHTML:</strong> You can use these tags: <code><?php echo allowed_tags(); ?></code></small></p>-->
        
                <p><textarea id="comment" name="comment" tabindex="4" cols="60" rows="7"></textarea></p>
        
                <p><input name="submit" type="submit" id="submitcomment" tabindex="5" value="Отправить" />
                    <?php comment_id_fields(); ?>
                    <!-- <input type="hidden" name="comment_post_ID" value="<?php //echo $id; ?>" /> -->
                </p>
                <?php do_action('comment_form', $post->ID); ?>
        
            </form>
        </div>

	<?php endif; // If registration required and not logged in ?>
    
	</div>
<?php endif; // if you delete this the sky will fall on your head ?>
