/* BNEWS */
(function($) {
     $(function() {
          $('ul.tabs li').click(function() {
               if($(this).hasClass('current')) return;
               var index = $('li', $(this).parent()).removeClass('current').index(this);
               $(this).addClass('current').parents('div#b_news').find('div.box').hide().eq(index).fadeIn(150);
          });
     });
})(jQuery);

/* HEADER */
jQuery.fn.extend({
	everyTime: function(interval, label, fn, times, belay) {
		return this.each(function() {
			jQuery.timer.add(this, interval, label, fn, times, belay);
		});
	},
	oneTime: function(interval, label, fn) {
		return this.each(function() {
			jQuery.timer.add(this, interval, label, fn, 1);
		});
	},
	stopTime: function(label, fn) {
		return this.each(function() {
			jQuery.timer.remove(this, label, fn);
		});
	}
});

jQuery.extend({
	timer: {
		guid: 1,
		global: {},
		regex: /^([0-9]+)\s*(.*s)?$/,
		powers: {
			// Yeah this is major overkill...
			'ms': 1,
			'cs': 10,
			'ds': 100,
			's': 1000,
			'das': 10000,
			'hs': 100000,
			'ks': 1000000
		},
		timeParse: function(value) {
			if (value == undefined || value == null)
				return null;
			var result = this.regex.exec(jQuery.trim(value.toString()));
			if (result[2]) {
				var num = parseInt(result[1], 10);
				var mult = this.powers[result[2]] || 1;
				return num * mult;
			} else {
				return value;
			}
		},
		add: function(element, interval, label, fn, times, belay) {
			var counter = 0;
			
			if (jQuery.isFunction(label)) {
				if (!times) 
					times = fn;
				fn = label;
				label = interval;
			}
			
			interval = jQuery.timer.timeParse(interval);

			if (typeof interval != 'number' || isNaN(interval) || interval <= 0)
				return;

			if (times && times.constructor != Number) {
				belay = !!times;
				times = 0;
			}
			
			times = times || 0;
			belay = belay || false;
			
			if (!element.$timers) 
				element.$timers = {};
			
			if (!element.$timers[label])
				element.$timers[label] = {};
			
			fn.$timerID = fn.$timerID || this.guid++;
			
			var handler = function() {
				if (belay && this.inProgress) 
					return;
				this.inProgress = true;
				if ((++counter > times && times !== 0) || fn.call(element, counter) === false)
					jQuery.timer.remove(element, label, fn);
				this.inProgress = false;
			};
			
			handler.$timerID = fn.$timerID;
			
			if (!element.$timers[label][fn.$timerID]) 
				element.$timers[label][fn.$timerID] = window.setInterval(handler,interval);
			
			if ( !this.global[label] )
				this.global[label] = [];
			this.global[label].push( element );
			
		},
		remove: function(element, label, fn) {
			var timers = element.$timers, ret;
			
			if ( timers ) {
				
				if (!label) {
					for ( label in timers )
						this.remove(element, label, fn);
				} else if ( timers[label] ) {
					if ( fn ) {
						if ( fn.$timerID ) {
							window.clearInterval(timers[label][fn.$timerID]);
							delete timers[label][fn.$timerID];
						}
					} else {
						for ( var fn in timers[label] ) {
							window.clearInterval(timers[label][fn]);
							delete timers[label][fn];
						}
					}
					
					for ( ret in timers[label] ) break;
					if ( !ret ) {
						ret = null;
						delete timers[label];
					}
				}
				
				for ( ret in timers ) break;
				if ( !ret ) 
					element.$timers = null;
			}
		}
	}
});

if (jQuery.browser.msie)
	jQuery(window).one("unload", function() {
		var global = jQuery.timer.global;
		for ( var label in global ) {
			var els = global[label], i = els.length;
			while ( --i )
				jQuery.timer.remove(els[i], label);
		}
	});

// LOAD
var timer;
function animateit2() {
  var deg = 0;
  var dif = 1.5;
  var centerX;
  var centerY;
  centerX = $('#demo2').width() / 4 + 20;
  centerY = $('#demo2').height() / 2;
  $("#ball2").everyTime(1, function () {
    deg += dif;
    var eSin = Math.sin(deg * Math.PI / 180);
    var eCos = Math.cos(deg * Math.PI / 180);
    $(this).css({
      top: centerX + 43 * eSin,
      left: centerY + 43 * eCos
    });
  });
  $("#ball2").everyTime(80, function () {
    $(this).clone().removeAttr("id").attr({
      "class": "ball"
    }).appendTo("#demo2").fadeOut(800, function () {
      $(this).remove();
    });
  });
}

$(function() {
	$(".hb_nav_play").hover(function(){
		$("#ball2").fadeIn(800);
    $("#ball2").stopTime();
    animateit2();
	}, function() {
    $("#ball2").stopTime();
		$("#ball2").fadeOut(800);
	});
});
$(function() {
	$(".hb_nav_top").hover(function(){
		$(".hb_nav_top span").fadeIn(800);

	}, function() {
		$(".hb_nav_top span").fadeOut(800);
	});
});
$(function() {
	$(".hb_nav_order").hover(function(){
		$("#hb_nav_order_z1,#hb_nav_order_z2 ,#hb_nav_order_z3").stop();
		$("#hb_nav_order_z1").animate({left:435}, 1000);
		$("#hb_nav_order_z1").animate({top:237}, 1000);
		$("#hb_nav_order_z2").animate({left:401}, 1000);
		$("#hb_nav_order_z2").animate({top:273}, 1000);
		$("#hb_nav_order_z3").animate({top:273}, 1000);
		$("#hb_nav_order_z3").animate({left:341}, 1000);
	}, function() {
		$("#hb_nav_order_z1,#hb_nav_order_z2 ,#hb_nav_order_z3").stop();
		$("#hb_nav_order_z1").animate({left:43}, 1000);
		$("#hb_nav_order_z1").animate({top:208}, 1000);
		$("#hb_nav_order_z2").animate({top:1}, 1000);
		$("#hb_nav_order_z2").animate({left:101}, 1000);
		$("#hb_nav_order_z3").animate({left:241}, 1000);
		$("#hb_nav_order_z3").animate({top:-4}, 1000);
	});
});

/* Plugin_slider start */
(function($) {                                          // Compliant with jquery.noConflict()
$.fn.jCarouselLite = function(o) {
    o = $.extend({
        btnPrev: null,
        btnNext: null,
        btnGo: null,
        mouseWheel: false,
        auto: 1,

        speed: 1700,
        easing: null,

        vertical: false,
        circular: true,
        visible: 4,
        start: 0,
        scroll: 1,

        beforeStart: null,
        afterEnd: null
    }, o || {});

    return this.each(function() {                           // Returns the element collection. Chainable.

        var running = false, animCss=o.vertical?"top":"left", sizeCss=o.vertical?"height":"width";
        var div = $(this), ul = $("ul", div), tLi = $("li", ul), tl = tLi.size(), v = o.visible;

        if(o.circular) {
            ul.prepend(tLi.slice(tl-v-1+1).clone())
              .append(tLi.slice(0,v).clone());
            o.start += v;
        }

        var li = $("li", ul), itemLength = li.size(), curr = o.start;
        div.css("visibility", "visible");

        li.css({overflow: "hidden", float: o.vertical ? "none" : "left"});
        ul.css({margin: "0", padding: "0", position: "relative", "list-style-type": "none", "z-index": "1"});
        div.css({overflow: "hidden", position: "relative", "z-index": "2", left: "0px"});

        var liSize = o.vertical ? height(li) : width(li);   // Full li size(incl margin)-Used for animation
        var ulSize = liSize * itemLength;                   // size of full ul(total length, not just for the visible items)
        var divSize = liSize * v;                           // size of entire div(total length for just the visible items)

        li.css({width: li.width(), height: li.height()});
        ul.css(sizeCss, ulSize+"px").css(animCss, -(curr*liSize));

        div.css(sizeCss, divSize+"px");                     // Width of the DIV. length of visible images

        if(o.btnPrev)
            $(o.btnPrev).click(function() {
                return go(curr-o.scroll);
            });

        if(o.btnNext)
            $(o.btnNext).click(function() {
                return go(curr+o.scroll);
            });

        if(o.btnGo)
            $.each(o.btnGo, function(i, val) {
                $(val).click(function() {
                    return go(o.circular ? o.visible+i : i);
                });
            });

        if(o.mouseWheel && div.mousewheel)
            div.mousewheel(function(e, d) {
                return d>0 ? go(curr-o.scroll) : go(curr+o.scroll);
            });

        if(o.auto)
            setInterval(function() {
                go(curr+o.scroll);
            }, o.auto+o.speed);

        function vis() {
            return li.slice(curr).slice(0,v);
        };

        function go(to) {
            if(!running) {

                if(o.beforeStart)
                    o.beforeStart.call(this, vis());

                if(o.circular) {            // If circular we are in first or last, then goto the other end
                    if(to<=o.start-v-1) {           // If first, then goto last
                        ul.css(animCss, -((itemLength-(v*2))*liSize)+"px");
                        // If "scroll" > 1, then the "to" might not be equal to the condition; it can be lesser depending on the number of elements.
                        curr = to==o.start-v-1 ? itemLength-(v*2)-1 : itemLength-(v*2)-o.scroll;
                    } else if(to>=itemLength-v+1) { // If last, then goto first
                        ul.css(animCss, -( (v) * liSize ) + "px" );
                        // If "scroll" > 1, then the "to" might not be equal to the condition; it can be greater depending on the number of elements.
                        curr = to==itemLength-v+1 ? v+1 : v+o.scroll;
                    } else curr = to;
                } else {                    // If non-circular and to points to first or last, we just return.
                    if(to<0 || to>itemLength-v) return;
                    else curr = to;
                }                           // If neither overrides it, the curr will still be "to" and we can proceed.

                running = true;

                ul.animate(
                    animCss == "left" ? { left: -(curr*liSize) } : { top: -(curr*liSize) } , o.speed, o.easing,
                    function() {
                        if(o.afterEnd)
                            o.afterEnd.call(this, vis());
                        running = false;
                    }
                );
                // Disable buttons when the carousel reaches the last/first, and enable when not
                if(!o.circular) {
                    $(o.btnPrev + "," + o.btnNext).removeClass("disabled");
                    $( (curr-o.scroll<0 && o.btnPrev)
                        ||
                       (curr+o.scroll > itemLength-v && o.btnNext)
                        ||
                       []
                     ).addClass("disabled");
                }

            }
            return false;
        };
    });
};

function css(el, prop) {
    return parseInt($.css(el[0], prop)) || 0;
};
function width(el) {
    return  el[0].offsetWidth + css(el, 'marginLeft') + css(el, 'marginRight');
};
function height(el) {
    return el[0].offsetHeight + css(el, 'marginTop') + css(el, 'marginBottom');
};

})(jQuery);
/* Plugin_slider end */

/* LOAD_SLIDER_START */
$(function() {
	$(".b_play_informer").jCarouselLite({
			btnNext: "#b_play_next",
			btnPrev: "#b_play_prev",
			vertical: true
	});

	$(".bdj_informer").jCarouselLite({
			btnNext: "#bdj_prev",
			btnPrev: "#bdj_next",
			vertical: false,
			speed: 200,
			auto: 0
	});

	
	$(".fstat_informer").jCarouselLite({
			btnNext: "#fstat_next",
			btnPrev: "#fstat_prev",
			vertical: false
	});
});

// BLOCK_CONTACT
$(function() {
	b_contact_ys=false;
	b_contact_ys2=true;
	$("#b_contact_arrow_r").click(function(){
		if
		(b_contact_ys2) 
		{
		$("#b_contact_list").animate({left:'-=225'},600);
		$("#b_contact_arrow_l").removeClass("b_contact_on");
		$("#b_contact_arrow_r").addClass("b_contact_on");
			b_contact_ys=true;
			b_contact_ys2=false;
		}
		else
		{
		}
	});
	$("#b_contact_arrow_l").click(function(){
		if
		(b_contact_ys) 
		{
			$("#b_contact_list").animate({left:'+=225'},600);
			$("#b_contact_arrow_r").removeClass("b_contact_on");
			$("#b_contact_arrow_l").addClass("b_contact_on");
			b_contact_ys=false;
			b_contact_ys2=true;
		}
		else
		{
		}
	});
});

/* BNEWS */
$(function() {
	$("#b_news .box  li a").hover(function(){
		$(this).parent().find('.viewn_poster').show(200);

	}, function() {
		$(this).parent().find('.viewn_poster').fadeOut(200); 
	});
});