/* template.js, Copyright (C) 2007 - 2010 YOOtheme GmbH */

var YOOTemplate = {
		
	start: function() {

		/* Match height of div tags */
		matchHeights();

		/* Accordion menu */
		new YOOAccordionMenu('div#middle ul.menu li.toggler', 'ul.accordion', { accordion: 'slide' });

		/* Dropdown menu */
		var dropdown = new YOODropdownMenu('menu', { mode: 'default', dropdownSelector: 'div.dropdown', transition: Fx.Transitions.Expo.easeOut });
		dropdown.matchUlHeight();

		/* set hover color */
		var submenuEnter = '#31302F';
		var submenuLeave = '#41403F';
		var submenu2Enter = '#303030';
		var submenu2Leave = '#393837';

		/* Morph: main menu - level2 (bg) */
		var menuEnter = { 'background-color': submenuEnter };
		var menuLeave = { 'background-color': submenuLeave };

		new YOOMorph('#menu a.level2, #menu a.level3', menuEnter, menuLeave,
			{ transition: Fx.Transitions.linear, duration: 0 },
			{ transition: Fx.Transitions.sineIn, duration: 500 });

		/* Morph: mod-fading sub menu - level1 (bg) */
		var submenuEnter = { 'background-color': submenuEnter };
		var submenuLeave = { 'background-color': submenuLeave };

		new YOOMorph('div.mod-sidebar ul.menu a.level1, div.mod-sidebar ul.menu span.level1', submenuEnter, submenuLeave,
			{ transition: Fx.Transitions.linear, duration: 0 },
			{ transition: Fx.Transitions.sineIn, duration: 300 });

		/* Morph: mod-fading sub menu - level2 (bg) */
		var submenuEnter = { 'background-color': submenu2Enter };
		var submenuLeave = { 'background-color': submenu2Leave };

		new YOOMorph('div.mod-sidebar ul.menu a.level2', submenuEnter, submenuLeave,
			{ transition: Fx.Transitions.linear, duration: 0 },
			{ transition: Fx.Transitions.sineIn, duration: 300 });

		/* Smoothscroll */
		new SmoothScroll({ duration: 500, transition: Fx.Transitions.Expo.easeOut });

		/* Match height of div tags */
		function matchHeights() {
			YOOBase.matchHeight('div.headerbox div.deepest', 20);
			YOOBase.matchHeight('div.topbox div.deepest', 20);
			YOOBase.matchHeight('div.bottombox div.deepest', 20);
			YOOBase.matchHeight('div.maintopbox div.deepest', 20);
			YOOBase.matchHeight('div.mainbottombox div.deepest', 20);
			YOOBase.matchHeight('div.contenttopbox div.deepest', 20);
			YOOBase.matchHeight('div.contentbottombox div.deepest', 20);
		}

	}

};

/* Add functions on window load */
window.addEvent('domready', YOOTemplate.start);