Function.prototype.bind = function(object) {
	var __method = this
	return function() {
		return __method.apply(object, arguments)
	}
}

var jacoolads = new Object()
jacoolads.CoolAds = function() {}
jacoolads.CoolAds.prototype = {
	initialize: function(el, duration) {
		this.el = el
		this.duration = duration
	},

	step: function() {
		var time  = (new Date).getTime()
		if (time >= this.duration+this.startTime) {
			this.now = this.to
			clearInterval (this.timer)
			this.timer = null
		}
		else {
			var Tpos = (time - this.startTime) / (this.duration)
			this.now = this.from - (Tpos) * (this.from-this.to)
		}
		this.increase()
	},

	show: function(from, to) {
		if (this.timer != null) return
		this.from = from
		this.to = to
		this.startTime = (new Date).getTime()
		this.timer = setInterval (this.step.bind(this), 13)
	},

	increase: function() {
		this.el.style.height = this.now + "px"
	}
}

var jacooladsdiv
var fx1

function initCoolAds() {
	show = getCookie("ja-coolads")
	if (show == null || !show) {
		jacooladsdiv = document.getElementById("ja-coolads")
		fx1 = new jacoolads.CoolAds()
		fx1.initialize(jacooladsdiv, anidur)
		setTimeout('showCoolAds()', watoap)
	}
}

function showCoolAds() {
	//jacooladsdiv.style.visibility = "visible"
	document.getElementById("ja-coolads-buttons").style.display = "block"
	setCookie("ja-coolads",1,waselo)
	fx1.show(0, jacooladsdiv.scrollHeight)
}

function hideCoolAds(showAgain) {
	fx1.show(jacooladsdiv.scrollHeight, 0)

	if (showAgain == 0) {
		setCookie("ja-coolads",1,365*24*60*60*1000)
	} else {
		setCookie("ja-coolads",1)
	}
	
	document.getElementById("ja-coolads-buttons").style.display = "none"
}

function getCookie(name) {
	var dc = document.cookie
	var prefix = name + "="
	var begin = dc.indexOf("; " + prefix)
	if (begin == -1) {
		begin = dc.indexOf(prefix)
		if (begin != 0) return null
	} else {
		begin += 2
	}
	var end = document.cookie.indexOf(";", begin)
	if (end == -1) {
		end = dc.length
	}
	return unescape(dc.substring(begin + prefix.length, end))
}

function setCookie(cookieName,cookieValue,expiration) {
	var today = new Date()
	var expire = new Date()
	if (expiration==null)
		document.cookie = cookieName+"="+escape(cookieValue) + ";path=/"
	else {
		expire.setTime(today.getTime() + expiration)
		document.cookie = cookieName+"="+escape(cookieValue) + ";expires="+expire.toGMTString() + ";path=/"
	}
}

//addEvent - attach a function to an event
function addEvent(obj, evType, fn){
	if (obj.addEventListener){
		obj.addEventListener(evType, fn, false)
		return true
	} else if (obj.attachEvent){
		var r = obj.attachEvent("on"+evType, fn)
		return r
	} else {
		return false
	}
}

//Attach to onload event
addEvent(window, 'load', initCoolAds)