﻿/**
 * RokIEWarn - An IE6 Warning to invite people upgrading to IE6
 * 
 * @version		1.2
 * 
 * @license		MIT-style license
 * @author		Djamil Legato <djamil@rockettheme.com>
 * @client		RocketTheme, LLC.
 * @copyright	Author
 */
 
 
var RokIEWarn = new Class({
	'site': 'sitename',
	'initialize': function() {
		var warning = "<h3>Вы просматриваете эту страницу из браузера Internet Explorer 6 (IE6).</h3><h4>Внимание!</h4><p>Последняя версия пакета обновлений для Internet Explorer 6 была выпущена в декабре 2004 года. После этой даты обновления для данного браузера не выпускаются. Компания Microsoft прекратила поддержку Internet Explorer 6, и продолжая использовать его Вы подвергаете свой компьютер и хранящиеся в нём данные огромному риску. Мы рекомендуем Вам как можно скорее скачать другой, более безопасный, быстрый и современный веб-браузер. Ниже представлены ссылки на страницы загрузки браузеров Opera или Firefox. Мы рекомендуем использовать любой из этих двух браузеров. Вы можете свернуть это уведомление используя кнопку справа.</p><br /><a class=\"external\" target=\"_blank\" href=\"../www.mozilla-europe.org/ru/firefox/default.htm\">Перейти на страницу загрузки Mozilla Firefox</a><br /><a class=\"external\" target=\"_blank\" href=\"../ru.opera.com/download/thanks/win/default.htm\">Перейти на страницу загрузки Opera</a>";
		
		this.box = new Element('div', {'id': 'iewarn'}).inject(document.body, 'top');
		var div = new Element('div').inject(this.box).setHTML(warning);
		
		var click = this.toggle.bind(this);
		var button = new Element('a', {'id': 'iewarn_close'}).addEvents({
			'mouseover': function() {
				this.addClass('cHover');
			},
			'mouseout': function() {
				this.removeClass('cHover');
			},
			'click': function() {
				click();	
			}
		}).inject(div, 'top');
		
		this.height = $('iewarn').getSize().size.y;
		
		this.fx = new Fx.Styles(this.box, {duration: 1000}).set({'margin-top': $('iewarn').getStyle('margin-top').toInt(), 'opacity': 0});
		this.open = false;
		
		var cookie = Cookie.get('rokIEWarn'), height = this.height;
		//cookie = 'open'; // added for debug to not use the cookie value
		if (!cookie || cookie == "open") this.show();
		else this.fx.set({'margin-top': -height, 'opacity': 0});

		
		return ;
	},
	
	'show': function() {
		this.fx.start({
			'margin-top': 0,
			'opacity': 1
		});
		this.open = true;
		Cookie.set('rokIEWarn', 'open', {duration: 7});
	},	
	'close': function() {
		var margin = this.height;
		this.fx.start({
			'margin-top': -margin,
			'opacity': 0
		});
		this.open = false;
		Cookie.set('rokIEWarn', 'close', {duration: 7});
	},	
	'status': function() {
		return this.open;
	},
	'toggle': function() {
		if (this.open) this.close();
		else this.show();
	}
});

window.addEvent('domready', function() {
	if (window.ie6) { (function() {var iewarn = new RokIEWarn();}).delay(2000); }
});