<?php

/***************************************************************************/
/*
/* 	----------------------------------------------------------------------
/* 						DO NOT EDIT THIS FILE
/*	----------------------------------------------------------------------
/* 
/*  			Original built by Darcy Clarke. http://themify.me
 * 				Extended by Elio Rivero.
/*  				Copyright (C) 2010 Themify
 * 
/*	----------------------------------------------------------------------
/*
/***************************************************************************/

	
/* 	Set Error Reporting
/***************************************************************************/
	error_reporting(E_ERROR);
	
	
/* 	Global Vars
/***************************************************************************/

	global $wpdb, $config, $data, $theme, $version, $notifications;

/*	Activate Theme
/***************************************************************************/

	if(isset($_GET['activated']) && $pagenow == "themes.php"){
		header('Location: '.admin_url().'admin.php?page=themify');
	}

/* 	Themify Framework Path and URI
/***************************************************************************/
	define( 'THEME_DIR', get_template_directory() );
	define( 'THEME_URI', get_template_directory_uri() );
	define( 'THEMIFY_DIR', THEME_DIR . '/themify' );
	define( 'THEMIFY_URI', THEME_URI . '/themify' );

/* 	Theme Config
/***************************************************************************/
	
	$version = "1.1.2";
	$theme = get_theme_data(TEMPLATEPATH . '/style.css');

/* 	Data Config
/***************************************************************************/

	init_db();
	$data = get_data();
	
/*	Generate Config from XML
/***************************************************************************/
	/**
	 *  @var String $the_config_file
	 */ 
	$the_config_file = (is_file(TEMPLATEPATH."/custom-config.xml"))? 'custom-config.xml' : 'theme-config.xml';
	$file = fopen(TEMPLATEPATH . "/" . $the_config_file, 'r');
	$config = fread($file, filesize(TEMPLATEPATH . "/" . $the_config_file));
	fclose($file);
	$config = themify_xml2array($config);
	$config = $config['config']['_c'];
		
	/*	Dynamic panel creation
	/**************************************************/
	
	$panels = $config['panel'];
	unset($config['panel']);
	if(is_array($panels)){
		foreach($panels as $panel){
			$config['panel'][strtolower($panel['_a']['title'])] = $panel['_c'];
		}
	}
	
/*	Generate Actions from Default Modules
/***************************************************************************/
		
	/*	Themify - CSS Header
	/**************************************************/
	add_action('wp_head', 'themify_get_css');
	
	/*	Themify - Insert settings page link in WP Admin Bar
	/**************************************************/
	add_action('wp_before_admin_bar_render', 'themify_admin_bar');
	
	/* Add support for feeds on the site */
	add_theme_support( 'automatic-feed-links' );
	
/**
 * Admin Only code follows
 ******************************************************/
if( is_admin() ){
	
	if( current_user_can('manage_options') ){
		/**
	 	* Themify - Admin Menu
	 	*******************************************************/
		add_action('admin_menu', 'themify_admin_nav');
		
		/**
	 	* Themify Updater
	 	*******************************************************/
		require_once(TEMPLATEPATH . '/themify/themify-updater.php');
	}
	
	/**
	 * Start tweaking TinyMCE
	 *******************************************************/
	/*require_once(THEMIFY_DIR . '/tinymce/class-themify-tinymce.php');
	add_action('init', create_function('', '$Themify_TinyMCE = new Themify_TinyMCE();'));*/
	
	/**
	 * Enqueue jQuery and other scripts
	 *******************************************************/
	add_action('admin_enqueue_scripts', 'themify_enqueue_scripts');
}

/**
 * Enqueue JS and CSS for Themify settings page and meta boxes
 * @param String $page
 * @since 1.1.1
 *******************************************************/
function themify_enqueue_scripts($page){
	if( $page == 'post.php' || $page == 'post-new.php' ){
		wp_enqueue_script( 'meta-box-tabs', get_template_directory_uri() . '/themify/js/meta-box-tabs.js', array('jquery'), '1.0', true );	
	}
	if( $page == 'post.php' || $page == 'post-new.php' || $page == 'toplevel_page_themify' ){
		//Enqueue styles
		wp_enqueue_style( 'themify-ui',  THEMIFY_URI . '/css/themify-ui.css'  );
		wp_enqueue_style( 'colorpicker', THEMIFY_URI . '/css/colorpicker.css' );
		
		//Enqueue scripts
		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-tabs' );
		wp_enqueue_script( 'swfobject' );
		wp_enqueue_script( 'validate', THEMIFY_URI . '/js/jquery.validate.pack.js', array('jquery') );
		wp_enqueue_script( 'uploadify', THEMIFY_URI . '/js/jquery.uploadify.min.js', array('jquery') );
		wp_enqueue_script( 'colorpicker-js', THEMIFY_URI . '/js/colorpicker.js', array('jquery') );
		wp_enqueue_script( 'themify-scripts', THEMIFY_URI . '/js/scripts.js', array('jquery'), date("Y-m-d") );
	}
}

function themify_admin_bar() {
	global $wp_admin_bar;
	if ( !is_super_admin() || !is_admin_bar_showing() )
		return;
	$wp_admin_bar->add_menu( array(
		'id' => 'themify-settings',
		'parent' => 'appearance',
		'title' => __( 'Themify Settings', 'themify' ),
		'href' => admin_url( 'admin.php?page=themify' )
	));
}


?>