<?php
defined('_JEXEC') or die;

/**
 * Template for Joomla! CMS, created with Artisteer.
 * See readme.txt for more details on how to use the template.
 */

require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'functions.php';

// Create alias for $this object reference:
$document = $this;

// Shortcut for template base url:
$templateUrl = $document->baseurl . '/templates/' . $document->template;

Artx::load("Artx_Page");

// Initialize $view:
$view = $this->artx = new ArtxPage($this);

// Decorate component with Artisteer style:
$view->componentWrapper();

JHtml::_('behavior.framework', true);

?>
<!DOCTYPE html>
<html dir="ltr" lang="<?php echo $document->language; ?>">
<head>
    <jdoc:include type="head" />
    <link rel="stylesheet" href="<?php echo $document->baseurl; ?>/templates/system/css/system.css" />
    <link rel="stylesheet" href="<?php echo $document->baseurl; ?>/templates/system/css/general.css" />

    <!-- Created by Artisteer v4.1.0.59782 -->
    
    
    <meta name="viewport" content="initial-scale = 1.0, maximum-scale = 1.0, user-scalable = no, width = device-width">

    <!--[if lt IE 9]><script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script><![endif]-->
    <link rel="stylesheet" href="<?php echo $templateUrl; ?>/css/template.css" media="screen">
    <!--[if lte IE 7]><link rel="stylesheet" href="<?php echo $templateUrl; ?>/css/template.ie7.css" media="screen" /><![endif]-->
    <link rel="stylesheet" href="<?php echo $templateUrl; ?>/css/template.responsive.css" media="all">

<link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <script>if ('undefined' != typeof jQuery) document._artxJQueryBackup = jQuery;</script>
    <script src="<?php echo $templateUrl; ?>/jquery.js"></script>
    <script>jQuery.noConflict();</script>

    <script src="<?php echo $templateUrl; ?>/script.js"></script>
    <?php $view->includeInlineScripts() ?>
    <script>if (document._artxJQueryBackup) jQuery = document._artxJQueryBackup;</script>
    <script src="<?php echo $templateUrl; ?>/script.responsive.js"></script>
</head>
<body>

<div id="za-main">
    <div class="za-sheet clearfix">
<header class="za-header clearfix"><?php echo $view->position('position-30', 'za-nostyle'); ?>


    <div class="za-shapes">

            </div>
<h1 class="za-headline" data-left="9.38%">
    <a href="<?php echo $document->baseurl; ?>/"><?php echo $this->params->get('siteTitle'); ?></a>
</h1>




<?php if ($view->containsModules('position-1', 'position-28', 'position-29')) : ?>
<nav class="za-nav clearfix">
    
<?php if ($view->containsModules('position-28')) : ?>
<div class="za-hmenu-extra1"><?php echo $view->position('position-28'); ?></div>
<?php endif; ?>
<?php if ($view->containsModules('position-29')) : ?>
<div class="za-hmenu-extra2"><?php echo $view->position('position-29'); ?></div>
<?php endif; ?>
<?php echo $view->position('position-1'); ?>
 
    </nav>
<?php endif; ?>

                    
</header>
<?php echo $view->position('position-15', 'za-nostyle'); ?>
<?php echo $view->positions(array('position-16' => 33, 'position-17' => 33, 'position-18' => 34), 'za-block'); ?>
<div class="za-layout-wrapper clearfix">
                <div class="za-content-layout">
                    <div class="za-content-layout-row">
                        <?php if ($view->containsModules('position-7', 'position-4', 'position-5')) : ?>
<div class="za-layout-cell za-sidebar1 clearfix">
<?php echo $view->position('position-7', 'za-block'); ?>
<?php echo $view->position('position-4', 'za-block'); ?>
<?php echo $view->position('position-5', 'za-block'); ?>




                        </div>
<?php endif; ?>

                        <div class="za-layout-cell za-content clearfix">
<?php
  echo $view->position('position-19', 'za-nostyle');
  if ($view->containsModules('position-2'))
    echo artxPost($view->position('position-2'));
  echo $view->positions(array('position-20' => 50, 'position-21' => 50), 'za-article');
  echo $view->position('position-12', 'za-nostyle');
  echo artxPost(array('content' => '<jdoc:include type="message" />', 'classes' => ' za-messages'));
  echo '<jdoc:include type="component" />';
  echo $view->position('position-22', 'za-nostyle');
  echo $view->positions(array('position-23' => 50, 'position-24' => 50), 'za-article');
  echo $view->position('position-25', 'za-nostyle');
?>



                        </div>
                        <?php if ($view->containsModules('position-6', 'position-8', 'position-3')) : ?>
<div class="za-layout-cell za-sidebar2 clearfix">
<?php echo $view->position('position-6', 'za-block'); ?>
<?php echo $view->position('position-8', 'za-block'); ?>
<?php echo $view->position('position-3', 'za-block'); ?>


                        </div>
<?php endif; ?>
                    </div>
                </div>
            </div>
<?php echo $view->positions(array('position-9' => 33, 'position-10' => 33, 'position-11' => 34), 'za-block'); ?>
<?php echo $view->position('position-26', 'za-nostyle'); ?>

<footer class="za-footer clearfix">
<?php if ($view->containsModules('position-27')) : ?>
    <?php echo $view->position('position-27', 'za-nostyle'); ?>
<?php else: ?>
<a title="RSS" class="za-rss-tag-icon" style="position: absolute; bottom: 5px; left: 6px; line-height: 32px;" href="#"></a><div style="position:relative;padding-left:10px;padding-right:10px"><p><a href="#">Link1</a> | <a href="#">Link2</a> | <a href="#">Link3</a></p><p>Copyright © 2013. All Rights Reserved.</p></div>
<?php endif; ?>
</footer>

    </div>
    <p class="za-page-footer">
        <span id="za-footnote-links">Designed by <a href="http://za-studio.net" target="_blank">Za studio</a>.</span>
    </p>
</div>



<?php echo $view->position('debug'); ?>
</body>
</html>