<?php get_header(); ?>

<div id="content" class="group">
<?php if (have_posts()) : ?>

<h2 class="archive">Результаты поиска</h2>

<?php while (have_posts()) : the_post(); ?>

<h2 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h2>
<p class="comments"><a href="<?php comments_link(); ?>"><?php comments_number('Ваш отзыв','Один отзыв','Отзывов (%)'); ?></a></p>

<div class="main">
	<?php the_content('Читать полностью &raquo;'); ?>
</div>

<div class="meta group">
<div class="signature">
    <p>Автор: <?php the_author() ?> <span class="edit"><?php edit_post_link('Править'); ?></span></p>
    <p><?php the_time('d M Y'); ?> <?php _e("в"); ?> <?php the_time('G:i'); ?></p>
</div>	
<div class="tags">
    <p>Рубрика: <?php the_category(',') ?></p>
    <?php if ( the_tags('<p>Метки: ', ', ', '</p>') ) ?>
</div>
</div>

<?php if ( comments_open() ) comments_template(); ?>

<?php endwhile; ?>
<div class="navigation">
	<div class="alignleft"><?php next_posts_link('&laquo; Предыдущая страница') ?></div>
	<div class="alignright"><?php previous_posts_link('Следующая страница &raquo;') ?></div>
</div>
<?php else : ?>
	<h2>No posts found.</h2>
	<div class="warning">
		<p>К сожалению, по вашему запросу ничего не найдено. Попробуете по другому запросу?</p>
	</div>
<?php endif; ?>

</div> 

<?php get_sidebar(); ?>

<?php get_footer(); ?>
