<?php get_header(); ?>

<div id="content">

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<h2 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h2>
<p class="comments"><a href="<?php comments_link(); ?>"><?php comments_number('Ваш отзыв','Один отзыв','Отзывов (%)'); ?></a></p>

<div class="main">
	<?php the_content('<p class="serif">Читать полностью &raquo;</p>'); ?>
	<?php wp_link_pages(array('before' => '<p><strong>Страницы:</strong> ', 'after' => '</p>', 'next_or_number' => 'number')); ?>
</div>

<div class="meta group">
<div class="signature">
    <p>Автор: <?php the_author() ?> <span class="edit"><?php edit_post_link('Править'); ?></span></p>
    <p><?php the_time('d M Y'); ?> <?php _e("в"); ?> <?php the_time('G:i'); ?></p>
</div>	
<div class="tags">
    <p>Posted in <?php the_category(',') ?></p>
    <?php if ( the_tags('<p>Метки: ', ', ', '</p>') ) ?>
</div>
</div>

<?php if ( comments_open() ) comments_template(); ?>

<?php endwhile; else: ?>
<div class="warning">
	<p>К сожалению, по вашему запросу ничего не найдено.</p>
</div>
<?php endif; ?>

</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
