<?php get_header(); ?>

<div id="content">
<?php if (have_posts()) : ?>

<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
<?php /* If this is a category archive */ if (is_category()) { ?>
<h2 class="archive">Рубрика: <?php single_cat_title(); ?></h2>
<?php /* If this is a tag */ } elseif (is_tag()) { ?>
<h2 class="archive">Метка: <?php single_tag_title(); ?></h2>
<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
<h2 class="archive">Архив за <?php the_time('d M Y'); ?></h2>
<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
<h2 class="archive">Архив за <?php the_time('F Y'); ?></h2>
<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
<h2 class="archive">Архив за <?php the_time('Y'); ?></h2>
<?php /* If this is an author archive */ } elseif (is_author()) { ?>
<h2 class="archive">Архив автора</h2>
<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
<h2 class="archive">Архив сайта</h2>
<?php } ?>

<?php while (have_posts()) : the_post(); ?>

<h2 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h2>
<p class="comments"><a href="<?php comments_link(); ?>"><?php comments_number('Ваш отзыв','Один отзыв','Отзывов (%)'); ?></a></p>

<div class="main">
	<?php the_content('Читать полностью &raquo;'); ?>
</div>

<div class="meta group">
<div class="signature">
    <p>Автор: <?php the_author() ?> <span class="edit"><?php edit_post_link('Править'); ?></span></p>
    <p><?php the_time('d M Y'); ?> <?php _e("в"); ?> <?php the_time('G:i'); ?></p>
</div>	
<div class="tags">
    <p>Рубрика: <?php the_category(',') ?></p>
    <?php if ( the_tags('<p>Метки: ', ', ', '</p>') ) ?>
</div>
</div>

<?php if ( comments_open() ) comments_template(); ?>

<?php endwhile; else: ?>
<div class="warning">
	<p>К сожалению, по вашему запросу ничего не найдено.</p>
</div>
<?php endif; ?>

<div class="navigation group">
	<div class="alignleft"><?php next_posts_link('&laquo; Предыдущая страница') ?></div>
	<div class="alignright"><?php previous_posts_link('Следующая страница &raquo;') ?></div>
</div>

</div> 

<?php get_sidebar(); ?>

<?php get_footer(); ?>
