<?php
$themename = "Shaan";
$shortname = "p2h";
$version = "1.1.3";

$option_group = $shortname.'_theme_option_group';
$option_name = $shortname.'_theme_options';


// Load stylesheet and jscript
add_action('admin_init', 'p2h_add_init');

function p2h_add_init() {
	$file_dir = get_template_directory_uri();
	wp_enqueue_style("p2hCss", $file_dir."/functions/theme-options.css", false, "1.0", "all");
	wp_enqueue_script("p2hScript", $file_dir."/functions/theme-options.js", false, "1.0");
}

// Create custom settings menu
add_action('admin_menu', 'p2h_create_menu');

function p2h_create_menu() {
	global $themename;
	//create new top-level menu
	add_theme_page( __( $themename.' Настройки темы' ), __( 'Theme Options' ), 'edit_theme_options', basename(__FILE__), 'p2h_settings_page' );
}

// Register settings
add_action( 'admin_init', 'register_settings' );

function register_settings() {
   global $themename, $shortname, $version, $p2h_options, $option_group, $option_name;
  	//register our settings
	register_setting( $option_group, $option_name);
}

//Automatically List StyleSheets in Folder
/////////////////////////////////////////////

$alt_stylesheet_path = TEMPLATEPATH . '/styles/';
$alt_stylesheets = array();

if ( is_dir($alt_stylesheet_path) ) {
    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) { 
        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) {
            if((stristr($alt_stylesheet_file, ".css") !== false) && (stristr($alt_stylesheet_file, "default") == false)){
                $alt_stylesheets[] = $alt_stylesheet_file;
            }
        }    
    }
}
array_unshift($alt_stylesheets, "default.css"); 

// Create theme options
global $p2h_options;
$p2h_options = array (

array("name" => __('Стили темы','shaan'),
		"type" => "section"),

array("name" => __('Выберите цветовую схему или добавьте свой собственный стиль.','shaan'),
		"type" => "section-desc"),
	
array("type" => "open"),

array("name" => __('Цветовая схема','shaan'), 
		"desc" => __('В будущей версии планируется несколько цветовых схем.','shaan'),
		"id" => "alt_stylesheet",
		"type" => "select",
		"options" => $alt_stylesheets,
		"std" => "default.css"),
		
array( "name" => __('Свои стили','shaan'),
	"desc" => __('Вы можете добавить  свой собственный CSS-код. Этот код перезаписывает любые другие идентичные стили. Например: a.button{color:green}','shaan'),
	"id" => "custom_css",
	"type" => "textarea",
	"std" => ""),

array("type" => "close"),

array("name" => __('RSS-ленты/Facebook/Twitter','shaan'),
		"type" => "section"),

array("name" => __('Настройка социальных ссылок.','shaan'),
		"type" => "section-desc"),
	
array("type" => "open"),

array("name" => __('Адрес RSS','shaan'),
		"desc" => __('Вы можете добавить свой собственный адрес RSS (<strong>начиная с http://</strong>). Например, ваш адрес в Feedburner.','shaan'),
		"id" => "feedurl",
		"type" => "text",
		"std" => get_bloginfo('rss2_url')),
	
array("name" => __('Удалить дополнительные ленты','shaan'),
		"desc" => __('WordPress добавляет ленты для рубрик, меток и т.п. по-умолчанию. Поставьте галочку, чтобы удалить их и навести порядок.','shaan'),
		"id" => "cleanfeedurls",
		"type" => "checkbox",
		"std" => ""),

array("name" => __('ID Twitter','shaan'),
		"desc" => __('Ваше имя в Twitter. Будет показано в панели навигации. Если оставить поле пустым, иконка Twitter не будет отображаться.','shaan'),
		"id" => "twitterid",
		"type" => "text",
		"std" => ""),

array("name" => __('Страница в Facebook','shaan'),
		"desc" => __('Ссылка на вашу страницу в Facebook, <strong>начиная с http://</strong>. Будет показано в панели навигации. Если оставить поле пустым, иконка Facebook не будет отображаться.','shaan'),
		"id" => "facebookid",
		"type" => "text",
		"std" => ""),
	
array("type" => "close"),

//FOOTER
array("name" => __('Подвал','shaan'),
		"type" => "section"),

array("name" => __('Настройка нижней части сайта.','shaan'),
		"type" => "section-desc"),
	
array("type" =>"open"),

array("name" => __('Текст в подвале','shaan'),
		"desc" => __('Введите текст или HTML здесь.','shaan'),
		"id" => "footer_text",
		"std" => "",
		"type" => "textarea"),

array("name" => __('Спрятать навигацию в подвале','shaan'),
		"desc" => __('Вы можете спрятать панель навигаци в нижней части сайта. Если же вы хотите настроить эту панель, вы можете это сделать во вкладке Внешний вид -> Меню.','shaan'),
		"id" => "hide_footer_nav",
		"std" => "",
		"type" => "checkbox"),

array("name" => __('Спрятать ссылки благодарности','shaan'),
		"desc" => __('Вы можете спрятать ссылки благодарности в нижней части сайта. Эти ссыли размещаются абсолютно по вашему желанию, но это будет <strong>огромный вклад</strong> в поддержку этой темы и мы будем очень благодарны.','shaan'),
		"id" => "hide_footer_credit",
		"std" => "",
		"type" => "checkbox"),

array( "type" => "close"),

//ADVERTISEMENTS --- POST ADS 
array("name" => __('Реклама','shaan'),
	"type" => "section"),

array("name" => __('Показывать рекламу на сайте.','shaan'),
		"type" => "section-desc"),
	
array("type" => "open"),

array("name" => __('Реклама в шапке','shaan'),
		"desc" => __('Вы можете показывать баннер 600px на 60px в шапке.','shaan'),
		"id" => "topbanner",
		"std" => "",
		"type" => "textarea"),

array("name" => __('Реклама над статьями','shaan'),
		"desc" => __('Введите ваш код Adsense или любой другой. Релкама будет показана перед статьями, под заголовком для Статей и Страниц. Это базовая и очень эффективная опция рекламы в блоге. Если вам нужно больше возможностей, вы можете воспользоваться готовыми плагинами других разработчиков.','shaan'),
		"id" => "posttop_adcode",
		"std" => "",
		"type" => "textarea"),

array("name" => __('Реклама под статьями','shaan'),
		"desc" => __('Введите ваш код Adsense или любой другой. Релкама будет показана под статьями. В Adsense допускается до трех рекламных блоков на страницу.','shaan'),
		"id" => "postend_adcode",
		"std" => "",
		"type" => "textarea"),

array("type" => "close"),

//Analytics Code
array("name" => __('Код статистики','shaan'),
		"type" => "section"),

array("name" => __('Введите свой код отслеживания статистики здесь.','shaan'),
		"type" => "section-desc"),
	
array("type" => "open"),

array("name" => __('Код Analytics и др.','shaan'),
		"desc" => __('Вы можете вставить свой код Google Analytics здесь, он будет автоматически добавлен в нижнюю часть сайта.','shaan'),
		"id" => "analytics_code",
		"type" => "textarea",
		"std" => ""),	

array("type" => "close")
);


function p2h_settings_page() {
   global $themename, $shortname, $version, $p2h_options, $option_group, $option_name;
?>

<div class="wrap">
<div class="options_wrap">
<?php screen_icon(); ?><h2><?php echo $themename; ?> <?php _e('Настройки темы','shaan'); ?></h2>
<p class="top-notice"><?php _e('Customize your WordPress blog with these settings. ','shaan'); ?></p>
<?php if ( isset ( $_POST['reset'] ) ): ?>
<?php // Delete Settings
global $wpdb, $themename, $shortname, $version, $p2h_options, $option_group, $option_name;
delete_option('p2h_theme_options');
wp_cache_flush(); ?>
<div class="updated fade"><p><strong><?php _e( $themename. ' настройки сброшены.' ); ?></strong></p></div>

<?php elseif ( isset ( $_REQUEST['save'] ) ): ?>
<div class="updated fade"><p><strong><?php _e( $themename. ' настройки сохранены.' ); ?></strong></p></div>
<?php endif; ?>

<form method="post" action="options.php">

<?php settings_fields( $option_group ); ?>

<?php $options = get_option( $option_name ); ?>        

<?php foreach ($p2h_options as $value) {
if ( isset($value['id']) ) { $valueid = $value['id'];}
switch ( $value['type'] ) {
case "section":
?>
	<div class="section_wrap">
	<h3 class="section_title"><?php echo $value['name']; ?> 

<?php break; 
case "section-desc":
?>
	<span><?php echo $value['name']; ?></span></h3>
	<div class="section_body">

<?php 
break;
case 'text':
?>

	<div class="options_input options_text">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label></span>
		<input name="<?php echo $option_name.'['.$valueid.']'; ?>" id="<?php echo $option_name.'['.$valueid.']'; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( isset( $options[$valueid]) ){ esc_attr_e($options[$valueid]); } else { esc_attr_e($value['std']); } ?>" />
	</div>

<?php
break;
case 'textarea':
?>
	<div class="options_input options_textarea">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label></span>
		<textarea name="<?php echo $option_name.'['.$valueid.']'; ?>" type="<?php echo $option_name.'['.$valueid.']'; ?>" cols="" rows=""><?php if ( isset( $options[$valueid]) ){ esc_attr_e($options[$valueid]); } else { esc_attr_e($value['std']); } ?></textarea>
	</div>

<?php 
break;
case 'select':
?>
	<div class="options_input options_select">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label></span>
		<select name="<?php echo $option_name.'['.$valueid.']'; ?>" id="<?php echo $option_name.'['.$valueid.']'; ?>">
		<?php foreach ($value['options'] as $option) { ?>
				<option <?php if ($options[$valueid] == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?>
		</select>
	</div>

<?php
break;
case "radio":
?>
	<div class="options_input options_select">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<span class="labels"><label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label></span>
		  <?php foreach ($value['options'] as $key=>$option) { 
			$radio_setting = $options[$valueid];
			if($radio_setting != ''){
				if ($key == $options[$valueid] ) {
					$checked = "checked=\"checked\"";
					} else {
						$checked = "";
					}
			}else{
				if($key == $value['std']){
					$checked = "checked=\"checked\"";
				}else{
					$checked = "";
				}
			}?>
			<input type="radio" id="<?php echo $option_name.'['.$valueid.']'; ?>" name="<?php echo $option_name.'['.$valueid.']'; ?>" value="<?php echo $key; ?>" <?php echo $checked; ?> /><?php echo $option; ?><br />
			<?php } ?>
	</div>

<?php
break;
case "checkbox":
?>
	<div class="options_input options_checkbox">
		<div class="options_desc"><?php echo $value['desc']; ?></div>
		<?php if( isset( $options[$valueid] ) ){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
		<input type="checkbox" name="<?php echo $option_name.'['.$valueid.']'; ?>" id="<?php echo $option_name.'['.$valueid.']'; ?>" value="true" <?php echo $checked; ?> />
		<label for="<?php echo $option_name.'['.$valueid.']'; ?>"><?php echo $value['name']; ?></label>
	 </div>

<?php
break;
case "close":
?>
</div><!--#section_body-->
</div><!--#section_wrap-->

<?php 
break;
}
}
?>

<span class="submit">
<input class="button button-primary" type="submit" name="save" value="<?php _e('Сохранить все изменения', 'shaan') ?>" />
</span>
</form>

<form method="post" action="">
<span class="button-right" class="submit">
<input class="button button-secondary" type="submit" name="reset" value="<?php _e('Сбросить/Удалить настройки', 'shaan') ?>" />
<input type="hidden" name="action" value="reset" />
<span><?php _e('Внимание: Все данные темы будут удалены из базы данных. Используйте, когда хотите полностью деинсталлировать тему.','shaan') ?></span>
</span>
</form>
</div><!--#options-wrap-->

<div class="sidebox">
	<h2>Поддержка <?php echo $themename; ?>!</h2>
	<p>Вы используете <strong><?php echo $themename; ?> <?php echo $version; ?></strong>, тему wordPress от <a href="http://www.speckygeek.com">Specky Geek</a>.</p>
	<p>Если вам понравилась эта тема, вы можете сделать пожертвование. Автор будет очень рад.</p>
	<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
	<input type="hidden" name="cmd" value="_s-xclick">
	<input type="hidden" name="hosted_button_id" value="6WPPE2PW6ERVC">
	<table>
	<tr><td><input type="hidden" name="on0" value="Reward for Shaan WP Theme">Reward for Shaan WP Theme</td></tr><tr><td><select name="os0">
		<option value="Twenty Five Dollars">Twenty Five Dollars $25.00</option>
		<option value="Ten Dollars">Ten Dollars $10.00</option>
		<option value="Fifteen Dollars">Fifteen Dollars $15.00</option>
		<option value="Twenty Dollars">Twenty Dollars $20.00</option>
		<option value="Twenty Five Dollars">Twenty Five Dollars $25.00</option>
		<option value="Thirty Five Dollars">Thirty Five Dollars $35.00</option>
		<option value="Fifty Dollars">Fifty Dollars $50.00</option>
		<option value="Hundred Dollars">Hundred Dollars $100.00</option>
	</select> </td></tr>
	</table>
	<input type="hidden" name="currency_code" value="USD">
	<input type="image" src="https://www.paypal.com/en_GB/i/btn/btn_paynow_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online.">
	<img alt="" border="0" src="https://www.paypal.com/en_GB/i/scr/pixel.gif" width="1" height="1">
	</form>
	<hr />
	<ul>
	<li><a href="http://www.speckygeek.com/">Specky Geek</a></li>
	<li><a href="http://www.speckygeek.com/wordpress-themes/">Free WordPress Themes</a></li>
	<li><a href="http://www.speckygeek.com/contact-us/">Связь с Specky Geek</a></li>
	</ul>
	<p>PS: Я не могу предоставить бесплатную поддержку. Пожалуйста, сделайте пожертвование, прежде чем просить о техподдержки.</p>
</div>
</div>
<?php } ?>