<?php get_header(); ?>

<div id="container">

	<div id="content" class="narrow">
	
	<?php if (have_posts()) : ?>
	
		<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
		
	<h1 class="page-title">
		<?php if (is_category()) : ?>
			<?php _e('Рубрика: ', 'shaan'); ?><span class="capitalize"><?php single_cat_title(); ?></span>
	 	<?php elseif( is_tag() ) : ?>
			<?php _e('Метка: ', 'shaan'); ?><span class="capitalize"><?php single_tag_title(); ?></span>
		<?php elseif (is_day()) : ?>
			<?php _e('Архив по дням: ', 'shaan'); ?><?php the_time('d M Y'); ?>
		<?php elseif (is_month()) : ?>
			<?php _e('Архив по месяцам:  ', 'shaan'); ?><?php the_time('F Y'); ?>
		<?php elseif (is_year()) : ?>
			<?php _e('Архив по годам: ', 'shaan'); ?><?php the_time('Y'); ?>
		<?php elseif (is_author()) : ?>
			<?php _e('Архив автора', 'shaan'); ?>
		<?php else : ?>
			<?php _e( 'Архив сайта', 'shaan' ); ?>
		<?php endif; ?>
	</h1>
			
		<?php while (have_posts()) : the_post();?>
		
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			
			<div class="post-thumb">
				<?php 
				if( has_post_thumbnail($post->ID) &&
				( /* $src, $width, $height */ $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'bigThumb' ) ) &&
				$image[1] >= 600 &&
				$image[2] >= 250 ) { ?>
				<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>">
				<?php // Use the image above post title
					echo get_the_post_thumbnail( $post->ID, 'bigThumb' ); ?>
				</a>
				<?php } ?>
			</div><!--  #post-thumb -->	

			
			<h2 class="post-title"><a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
			<p class="post-meta"><?php the_author_posts_link(); ?>  &diams;  <a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_time('d M Y') ?></a>  &diams;  <?php comments_popup_link( __('Ваш отзыв', 'shaan'), __( '1 отзыв', 'shaan'), __('Отзывов (%)', 'shaan')); ?><?php if(is_sticky()) {?>  &diams;  <?php _e('Прикреплено','shaan'); ?><?php } ?></p>
			
			<?php 
				if( has_post_thumbnail($post->ID) &&
				( /* $src, $width, $height */ $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'post-thumbnail' ) ) &&
				$image[1] < 600 ) {
				// Use as small thumbnail beow headline ?>
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute( ); ?>" rel="bookmark">
				<?php echo get_the_post_thumbnail( $post->ID, 'thumbnail', 'class=home-thumb-small alignleft'); ?>
				</a>
			<?php } ?>
			
			<?php the_excerpt(); ?>

		</div><!--#posts-->

		<?php endwhile; ?>

		<?php if (function_exists('wp_pagenavi')) { wp_pagenavi(); } else { include('navigation.php'); } ?>

		
	<?php else : ?>
		
		<h2 class="page-title"><?php _e('Не найдено', 'shaan'); ?></h2>
		<p><?php _e('К сожалению, по вашему запросу ничего не найдено.', 'shaan'); ?></p>
		<?php get_search_form(); ?>
		
	<?php endif; ?>

	</div><!-- #content -->
	
		
	<?php get_sidebar(); ?>
	<?php get_footer(); ?>
