<?php
/**
 * @package WordPress
 * @subpackage Default_Theme
 */

get_header();
?>
<div>

	<div id="content" class="narrowcolumn">

		<?php if (have_posts()) : ?>

 	  <?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
 	  <?php /* If this is a category archive */ if (is_category()) { ?>
		<h2 class="pagetitle"><?php single_cat_title(); ?></h2>
 	  <?php /* If this is a tag archive */ } elseif( is_tag() ) { ?>
		<h2 class="pagetitle">Метка: <?php single_tag_title(); ?></h2>
 	  <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h2 class="pagetitle">Архив за <?php the_time('d M Y'); ?></h2>
 	  <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h2 class="pagetitle">Архив за <?php the_time('F Y'); ?></h2>
 	  <?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h2 class="pagetitle">Архив за <?php the_time('Y'); ?></h2>
	  <?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h2 class="pagetitle">Архив автора</h2>
 	  <?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h2 class="pagetitle">Архив сайта</h2>
 	  <?php } ?>


		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('&laquo; Предыдущая страница') ?></div>
			<div class="alignright"><?php previous_posts_link('Следующая страница &raquo;') ?></div>
		</div>

		<?php while (have_posts()) : the_post(); ?>
		
		<div  class="date_style">
		<span  class="date1"><?php the_time('d');   ?></span><br/>
		<span  class="month"><?php the_time('F');   ?></span><br/>
		<span  class="time"><?php the_time('Y');   ?></span>
		
		</div>

<div  class="name_style">


		<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
				<div class="post_title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Постоянная ссылка: <?php the_title_attribute(); ?>" ><?php the_title(); ?></a></div>
				<div style=" color:#264E82;">Автор:&nbsp;<font color="#000000"><?php the_author() ?></font>&nbsp;&nbsp;<?php echo "Рубрика:"; ?>&nbsp;<?php the_category(', ') ?></div>
				
				</div>
				</div>
				<div style="clear:both;"></div>
				<div class="entry">
				<?php the_content('Далее... &raquo;'); ?>
				</div>
				<div class="post_comm">
	<?php comments_popup_link('Ваш отзыв', '1 отзыв', 'Отзывов (%)'); ?>&nbsp;&nbsp;<?php the_tags('Метки: ', ', ', '') ?></div>
			

		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('&laquo; Предыдущая страница') ?></div>
			<div class="alignright"><?php previous_posts_link('Следующая страница &raquo;') ?></div>
		</div>
	
	<?php else :

		if ( is_category() ) { // If this is a category archive
			printf("<h2 class='center'>К сожалению, в рубрике &laquo;%s&raquo; еще ничего не опубликовано.</h2>", single_cat_title('',false));
		} else if ( is_date() ) { // If this is a date archive
			echo("<h2>К сожалению, за эту дату ничего не опубликовано.</h2>");
		} else if ( is_author() ) { // If this is a category archive
			$userdata = get_userdatabylogin(get_query_var('author_name'));
			printf("<h2 class='center'>К сожалению, автор %s еще ничего не опубликовал.</h2>", $userdata->display_name);
		} else {
			echo("<h2 class='center'>Ничего не найдено.</h2>");
		}
		get_search_form();

	endif;
?>

	</div>

<?php get_sidebar(); ?>
</div>
<?php get_footer(); ?>
