<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php if (function_exists('language_attributes')) { language_attributes(); } ?>>
<head profile="http://gmpg.org/xfn/11">
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
	<title>
		<?php if ( !is_home() && !is_page() && !is_single() ) { navigation_title(); }
		else {
			wp_title(''); 
		}
		if(wp_title(' ', false)) { echo ' &ndash; '; }
		bloginfo('name'); 
		?>
	</title>
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats -->
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
	<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<link rel="shortcut icon" type="image/x-ico" href="<?php bloginfo('stylesheet_directory'); ?>/favicon.ico" />	
<!--[if IE]><link rel="stylesheet" href="<?php bloginfo('stylesheet_directory'); ?>/ie.css" type="text/css" media="screen" /><![endif]-->	
	<?php if ( is_singular() ) { wp_enqueue_script( 'comment-reply' ); } ?>
<?php wp_head(); ?>
</head>
<?php 
	$bodyclass = "";
	if (is_home()) { $bodyclass = "home"; }
	if (is_single()) { $bodyclass = "single"; } 
	if (is_404()) { $bodyclass = "missing"; }
	if (is_archive()) { $bodyclass = "error"; }
	if (is_search()) { $bodyclass = "search"; }
	if (is_page()) { $bodyclass = "page"; }
	if (is_tag()) { $bodyclass = "tag"; }
?>
<body class="<?php echo $bodyclass; ?>"><div id="wrap">
<div id="header">
	<h1><a href="<?php bloginfo('home'); ?>"><?php bloginfo('name'); ?></a></h1>
	<?php include( TEMPLATEPATH . '/menu.php' ); ?>
</div>
<div id="main"><div id="posts" class="clear">