<?php get_header(); ?>

<div id="container">
<div id="header">
  <p><a href="<?php bloginfo('url'); ?>/">
    <?php bloginfo('name'); ?>
    </a><br />
    <?php bloginfo('description'); ?>
  </p>
</div>
<div id="hmenu">
  <ul class="navmenu">
    <?php wp_list_pages('title_li=&depth=1&'.$page_sort.'&'.$pages_to_exclude)?>
  </ul>
</div>
<div id="content">
  <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
  <div class="post" id="post-<?php the_ID(); ?>">
    <h1><a href="<?php the_permalink() ?>" rel="bookmark">
      <?php the_title(); ?>
      </a></h1>
    <div class="meta">
      <?php _e("Рубрика"); ?>: 
      <?php the_category(',') ?>
      &#8212;
      <?php the_author() ?>
      <?php the_date(); ?>
      в
      <?php the_time() ?>
      <?php edit_post_link(__('Редактировать')); ?>
    </div>
    <div class="storycontent">
      <?php the_content(__('Читать дальше...')); ?>
    </div>
    <?php wp_link_pages(); ?>
  </div>
  <?php comments_template(); // Get wp-comments.php template ?>
  <?php endwhile; else: ?>
  <p>
    <?php _e('Извините, по вашему запросу ничего не найдено.'); ?>
  </p>
  <?php endif; ?>
  <div id="next">
    <?php posts_nav_link(' - ', __('<<< Предыдущая страница'), __('Следующая страница >>>')); ?>
  </div>
</div>
<?php get_sidebar(); ?>
<div style="clear: both"></div>
<?php get_footer(); ?>
